/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.fw.schedops.DisplayData;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;
import java.util.Date;

class DisplayDataImpl
implements DisplayData,
Serializable {
    private static final String KEY_HMC = "XTIM.IF.HMC";
    private static final String KEY_HMCAPI = "XTIM.IF.HMCAPI";
    private static final String KEY_HMCLIC = "XTIM.IF.HMCLIC";
    private static final String KEY_OPSMGMT = "XTIM.IF.OPSMGMT";
    private static final String KEY_SCLP = "XTIM.IF.SCLP";
    private static final String KEY_SE = "XTIM.IF.SE";
    private static final String KEY_SELIC = "XTIM.IF.SELIC";
    private static final String KEY_UNKNOWN = "XTIM.IF.UNKNOWN";
    private Integer uniqueID;
    private LocalizableText name;
    private LocalizableText description;
    private Date scheduledDate;
    private long windowOfOpportunity;
    private long remainingRepetitions;
    private long schedulingFrequency;
    private Date creationDate;
    private LocalizableText creationInterface;
    private LocalizableText creationUserid;
    private LocalizableText creationSourceNetID;
    private LocalizableText creationSourceName;

    DisplayDataImpl(Integer id, ScheduledOperation schedop) {
        this.uniqueID = new Integer(id);
        this.name = schedop.getOperationTarget().getDisplayableName();
        this.description = schedop.getSchedulable().getDescriptor().getDescription();
        Schedule schedule = schedop.getSchedule();
        Date schedDate = new Date();
        Date startWOO = schedop.getLastExecutionDate();
        Date endWOO = null;
        if (schedop.getLastExecutionDate() != null) {
            endWOO = new Date(startWOO.getTime() + schedule.getWindowOfOpportunity());
            if (startWOO.getTime() <= schedDate.getTime() && schedDate.getTime() <= endWOO.getTime() && schedop.getLastExecutionStatus()) {
                schedDate = new Date(endWOO.getTime() + 1000L);
            }
        }
        this.scheduledDate = schedop.getSchedule().getNextScheduledDate(schedDate);
        if (this.scheduledDate == null) {
            this.scheduledDate = schedop.getLastExecutionDate();
        }
        this.remainingRepetitions = schedop.getSchedule().getRemainingRepetitions(schedDate);
        this.windowOfOpportunity = schedop.getSchedule().getWindowOfOpportunity();
        this.schedulingFrequency = schedop.getSchedule().getSchedulingFrequency();
        this.creationDate = schedop.getCreationDate();
        this.creationUserid = schedop.getCreationUserid();
        this.creationSourceNetID = schedop.getCreationSourceNetID();
        this.creationSourceName = schedop.getCreationSourceName();
        int intf = schedop.getCreationInterface();
        switch (intf) {
            case 41227: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_HMC);
                break;
            }
            case 41225: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_HMCAPI);
                break;
            }
            case 41229: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_HMCLIC);
                break;
            }
            case 41230: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_OPSMGMT);
                break;
            }
            case 41224: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_SCLP);
                break;
            }
            case 41226: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_SE);
                break;
            }
            case 41228: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_SELIC);
                break;
            }
            case 0: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_UNKNOWN);
                break;
            }
            default: {
                this.creationInterface = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", KEY_UNKNOWN);
            }
        }
    }

    public Integer getUniqueID() {
        return this.uniqueID;
    }

    public LocalizableText getObjectName() {
        return this.name;
    }

    public LocalizableText getOperationDescription() {
        return this.description;
    }

    public Date getScheduledDate() {
        return this.scheduledDate;
    }

    public long getRemainingRepetitions() {
        return this.remainingRepetitions;
    }

    public long getSchedulingFrequency() {
        return this.schedulingFrequency;
    }

    public long getWindowOfOpportunity() {
        return this.windowOfOpportunity;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public LocalizableText getCreationInterface() {
        return this.creationInterface;
    }

    public LocalizableText getCreationUserid() {
        return this.creationUserid;
    }

    public LocalizableText getCreationSourceNetID() {
        return this.creationSourceNetID;
    }

    public LocalizableText getCreationSourceName() {
        return this.creationSourceName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("[ID=");
        buffer.append(this.uniqueID);
        buffer.append(";NAME=");
        buffer.append(this.name);
        buffer.append(";DESCRIPTION=");
        buffer.append(this.description);
        buffer.append(";DATE=");
        buffer.append(this.scheduledDate);
        buffer.append(";WINDOW=");
        buffer.append(this.windowOfOpportunity);
        buffer.append(";REPETITIONS=");
        buffer.append(this.remainingRepetitions);
        buffer.append(";FREQUENCY=");
        buffer.append(this.schedulingFrequency);
        return buffer.toString();
    }
}

